# import des different composants necessaires
from vtk import *

nom_du_fichier = "test.vtk"

# ------------------------------------------------
# Lecture du dataset
# ------------------------------------------------
reader = vtkDataSetReader()
reader.SetFileName(nom_du_fichier)
reader.Update()
reader.CloseVTKFile()

# ------------------------------------------------
# fin de la lecture
# ------------------------------------------------
dataset = reader.GetOutput()
outputPort = reader.GetOutputPort()

# ------------------------------------------------
# creation du pipeline de visualisation par defaut
# ------------------------------------------------
    
mapper = vtkDataSetMapper()
mapper.SetInput(dataset)
    
actor = vtkActor()
actor.SetMapper(mapper)
    
#  ------------------------------------------------
# Fin de la definition du pipeline
#  ------------------------------------------------

#  ------------------------------------------------
# Integration de l'acteur dans la vue 3D
#  ------------------------------------------------
cassandra.getPipeLineManager().addDataSet( dataset,"Data")
cassandra.getPipeLineManager().addMapper(mapper, "")
actorCassandra = cassandra.getPipeLineManager().addActor(actor, "DataView")
cassandra.getPipeLineManager().setActorVisible(actorCassandra,1)
cassandra.getPipeLineManager().validateViewAndWait()
        